VERSION 5.00
Begin VB.Form MainForm 
   Caption         =   "StarIO Sample"
   ClientHeight    =   4725
   ClientLeft      =   120
   ClientTop       =   420
   ClientWidth     =   4560
   LinkTopic       =   "Form1"
   ScaleHeight     =   4725
   ScaleWidth      =   4560
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command_ReadPort_Usage 
      Caption         =   "ReadPort Usage"
      Height          =   375
      Left            =   120
      TabIndex        =   9
      Top             =   1800
      Width           =   4335
   End
   Begin VB.CommandButton Command_EndCheckedBlockEx_Usage 
      Caption         =   "EndCheckedBlockEx Usage"
      Height          =   375
      Left            =   120
      TabIndex        =   8
      Top             =   3600
      Width           =   4335
   End
   Begin VB.CommandButton Command_ResetDevice_Usage 
      Caption         =   "ResetDevice Usage"
      Height          =   375
      Left            =   120
      TabIndex        =   7
      Top             =   4200
      Width           =   4335
   End
   Begin VB.CommandButton Command_GetOnlineStatus_Usage 
      Caption         =   "GetOnlineStatus Usage"
      Height          =   375
      Left            =   120
      TabIndex        =   6
      Top             =   2400
      Width           =   4335
   End
   Begin VB.CommandButton Command_GetParsedStatusEx_Usage 
      Caption         =   "GetParsedStatusEx Usage"
      Height          =   375
      Left            =   120
      TabIndex        =   5
      Top             =   3000
      Width           =   4335
   End
   Begin VB.CommandButton Command_WritePort_Usage 
      Caption         =   "WritePort Usage"
      Height          =   375
      Left            =   120
      TabIndex        =   4
      Top             =   1200
      Width           =   4335
   End
   Begin VB.TextBox Text_PortSettings 
      Height          =   375
      Left            =   1560
      TabIndex        =   3
      Top             =   600
      Width           =   2895
   End
   Begin VB.TextBox Text_PortName 
      Height          =   375
      Left            =   1560
      TabIndex        =   1
      Top             =   120
      Width           =   2895
   End
   Begin VB.Label Label2 
      Caption         =   "Port Settings"
      Height          =   375
      Left            =   120
      TabIndex        =   2
      Top             =   600
      Width           =   1335
   End
   Begin VB.Label Label1 
      Caption         =   "Port Name"
      Height          =   375
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1335
   End
End
Attribute VB_Name = "MainForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Base 0
Option Explicit

Private Sub Command_EndCheckedBlockEx_Usage_Click()

    Dim portName As String
    portName = Text_PortName.Text
    If Len(portName) = 0 Then
        portName = ""
    End If
    
    Dim portSettings As String
    portSettings = Text_PortSettings.Text
    If Len(portSettings) = 0 Then
        portSettings = ""
    End If
    
    Dim port As Long
    port = OpenPortA(portName, portSettings, 10 * 1000)
    If port = 0 Then
        MsgBox "OpenPortA failed.", vbOKOnly, "StarIO Sample"
        Exit Sub
    End If
    
    Dim starPrinterStatus As StarPrinterStatus_2
    
    If BeginCheckedBlockEx(port, starPrinterStatus, 2) = 0 Then
        ClosePort (port)
        MsgBox "BeginCheckedBlockEx failed.", vbOKOnly, "StarIO Sample"
        Exit Sub
    End If
    
    If starPrinterStatus.offline <> 0 Then
        ClosePort (port)
        MsgBox "Cannot print because the printer is offline.", vbOKOnly, "StarIO Sample"
        Exit Sub
    End If

    Dim i As Long
    For i = 0 To 49
        Dim command() As Byte
        command = StrConv("Hello World." & vbLf, vbFromUnicode)
        
        If WritePortHelper(port, command) <> UBound(command) + 1 Then
            ClosePort (port)
            MsgBox "WritePort failed.", vbOKOnly, "StarIO Sample"
            Exit Sub
        End If
    Next i

    If EndCheckedBlockEx(port, starPrinterStatus, 2) = 0 Then
        ClosePort (port)
        MsgBox "EndCheckedBlockEx failed.", vbOKOnly, "StarIO Sample"
        Exit Sub
    End If
    
    If starPrinterStatus.offline <> 0 Then
        ClosePort (port)
        MsgBox "The printer is offline indicating that the printing failed.", vbOKOnly, "StarIO Sample"
        Exit Sub
    End If
    
    ClosePort (port)
    
    MsgBox "Completed successfully.", vbOKOnly, "StarIO Sample"
End Sub

Private Sub Command_GetOnlineStatus_Usage_Click()

    Dim portName As String
    portName = Text_PortName.Text
    If Len(portName) = 0 Then
        portName = ""
    End If
    
    Dim portSettings As String
    portSettings = Text_PortSettings.Text
    If Len(portSettings) = 0 Then
        portSettings = ""
    End If
    
    Dim port As Long
    port = OpenPortA(portName, portSettings, 10 * 1000)
    If port = 0 Then
        MsgBox "OpenPortA failed.", vbOKOnly, "StarIO Sample"
        Exit Sub
    End If

    Dim onlineStatus As Long
    If GetOnlineStatus(port, onlineStatus) = 0 Then
        ClosePort (port)
        MsgBox "GetOnlineStatus failed.", vbOKOnly, "StarIO Sample"
        Exit Sub
    End If
    
    If onlineStatus = 0 Then
        MsgBox "The printer is offline.", vbOKOnly, "StarIO Sample"
    Else
        MsgBox "The printer is online.", vbOKOnly, "StarIO Sample"
    End If
    
    ClosePort (port)
    
    MsgBox "Completed successfully.", vbOKOnly, "StarIO Sample"
End Sub

Private Sub Command_GetParsedStatusEx_Usage_Click()

    Dim portName As String
    portName = Text_PortName.Text
    If Len(portName) = 0 Then
        portName = ""
    End If
    
    Dim portSettings As String
    portSettings = Text_PortSettings.Text
    If Len(portSettings) = 0 Then
        portSettings = ""
    End If
    
    Dim port As Long
    port = OpenPortA(portName, portSettings, 10 * 1000)
    If port = 0 Then
        MsgBox "OpenPortA failed.", vbOKOnly, "StarIO Sample"
        Exit Sub
    End If

    Dim starPrinterStatus As StarPrinterStatus_2
    If GetParsedStatusEx(port, starPrinterStatus, 2) = 0 Then
        ClosePort (port)
        MsgBox "GetParsedStatusEx failed.", vbOKOnly, "StarIO Sample"
        Exit Sub
    End If
    
    If starPrinterStatus.offline <> 0 Then
        If starPrinterStatus.coverOpen <> 0 Then
            MsgBox "The printer is offline because the cover is open.", vbOKOnly, "StarIO Sample"
        ElseIf starPrinterStatus.receiptPaperEmpty <> 0 Then
            MsgBox "The printer is offline because it's out of paper.", vbOKOnly, "StarIO Sample"
        Else
            MsgBox "The printer is offline.", vbOKOnly, "StarIO Sample"
        End If
    Else
        MsgBox "The printer is online.", vbOKOnly, "StarIO Sample"
    End If
    
    ClosePort (port)
    
    MsgBox "Completed successfully.", vbOKOnly, "StarIO Sample"
End Sub

Private Sub Command_ReadPort_Usage_Click()

    Dim portName As String
    portName = Text_PortName.Text
    If Len(portName) = 0 Then
        portName = ""
    End If
    
    Dim portSettings As String
    portSettings = Text_PortSettings.Text
    If Len(portSettings) = 0 Then
        portSettings = ""
    End If
    
    Dim port As Long
    port = OpenPortA(portName, portSettings, 10 * 1000)
    If port = 0 Then
        MsgBox "OpenPortA failed.", vbOKOnly, "StarIO Sample"
        Exit Sub
    End If

    Dim firmwareNameRequestCommand(0 To 4) As Byte
    firmwareNameRequestCommand(0) = &H1B
    firmwareNameRequestCommand(1) = Asc("#")
    firmwareNameRequestCommand(2) = Asc("*")
    firmwareNameRequestCommand(3) = &HA
    firmwareNameRequestCommand(4) = &H0

    If WritePortHelper(port, firmwareNameRequestCommand) <> UBound(firmwareNameRequestCommand) + 1 Then
        ClosePort (port)
        MsgBox "WritePort failed.", vbOKOnly, "StarIO Sample"
        Exit Sub
    End If

    Dim firmwareNameBuffer(0 To 99) As Byte
    Dim firmwareNameBufferIdx As Long
    
    Dim wrongCount As Long
    Dim readState_init, readState_inFirmwareName_1, readState_inFirmwareName_2, readState_inFirmwareName_3, readState_inFirmwareName_4, readState_inFirmwareName_5, readState_done As Long
    Dim readState As Long
    
    wrongCount = 0
    readState_init = 0
    readState_inFirmwareName_1 = 1
    readState_inFirmwareName_2 = 2
    readState_inFirmwareName_3 = 3
    readState_inFirmwareName_4 = 4
    readState_inFirmwareName_5 = 5
    readState_done = 6
    readState = readState_init
    
    Do While (readState <> readState_done) And (wrongCount < 50)
        Dim inputBuffer(0 To 1023) As Byte
        Dim sizeRead As Long
        If ReadPort(port, inputBuffer(0), UBound(inputBuffer) + 1, sizeRead) = 0 Then
            ClosePort (port)
            MsgBox "ReadPort failed.", vbOKOnly, "StarIO Sample"
            Exit Sub
        End If
        If (sizeRead = 0) Then
            Exit Do
        End If
    
        Dim inputIdx As Long
        For inputIdx = 0 To sizeRead - 1
            If (readState = readState_init) And (inputBuffer(inputIdx) = &H1B) Then
                readState = readState_inFirmwareName_1
            ElseIf (readState = readState_inFirmwareName_1) And (inputBuffer(inputIdx) = Asc("#")) Then
                readState = readState_inFirmwareName_2
            ElseIf (readState = readState_inFirmwareName_2) And (inputBuffer(inputIdx) = Asc("*")) Then
                readState = readState_inFirmwareName_3
            ElseIf (readState = readState_inFirmwareName_3) And (inputBuffer(inputIdx) = Asc(",")) Then
                readState = readState_inFirmwareName_4
            ElseIf (readState = readState_inFirmwareName_4) And (inputBuffer(inputIdx) = &HA) Then
                readState = readState_inFirmwareName_5
            ElseIf (readState = readState_inFirmwareName_5) And (inputBuffer(inputIdx) = &H0) Then
                readState = readState_done
                Exit For
            ElseIf (readState = readState_inFirmwareName_4) Then
                firmwareNameBuffer(firmwareNameBufferIdx) = inputBuffer(inputIdx)
                firmwareNameBufferIdx = firmwareNameBufferIdx + 1
            Else
                readState = readState_init
                wrongCount = wrongCount + 1
                firmwareNameBufferIdx = 0
            End If
        Next inputIdx
    Loop
    
    If readState = readState_done Then
        firmwareNameBuffer(firmwareNameBufferIdx) = 0
        
        Dim firmwareName As String
        firmwareName = Left(StrConv(firmwareNameBuffer, vbUnicode), firmwareNameBufferIdx)
        
        MsgBox "The firmware name is: " & firmwareName, vbOKOnly, "StarIO Sample"
    Else
        ClosePort (port)
        MsgBox "Could not read the firmware name.", vbOKOnly, "StarIO Sample"
        Exit Sub
    End If
    
    ClosePort (port)
    
    MsgBox "Completed successfully.", vbOKOnly, "StarIO Sample"

End Sub

Private Sub Command_ResetDevice_Usage_Click()

    Dim portName As String
    portName = Text_PortName.Text
    If Len(portName) = 0 Then
        portName = ""
    End If
    
    Dim portSettings As String
    portSettings = Text_PortSettings.Text
    If Len(portSettings) = 0 Then
        portSettings = ""
    End If
    
    Dim port As Long
    port = OpenPortA(portName, portSettings, 10 * 1000)
    If port = 0 Then
        MsgBox "OpenPortA failed.", vbOKOnly, "StarIO Sample"
        Exit Sub
    End If

    If ResetDevice(port) = 0 Then
        ClosePort (port)
        MsgBox "ResetDevice failed.", vbOKOnly, "StarIO Sample"
        Exit Sub
    End If
    
    ClosePort (port)
    
    MsgBox "Completed successfully.", vbOKOnly, "StarIO Sample"
End Sub

Private Sub Command_WritePort_Usage_Click()

    Dim portName As String
    portName = Text_PortName.Text
    If Len(portName) = 0 Then
        portName = ""
    End If
    
    Dim portSettings As String
    portSettings = Text_PortSettings.Text
    If Len(portSettings) = 0 Then
        portSettings = ""
    End If
    
    Dim port As Long
    port = OpenPortA(portName, portSettings, 10 * 1000)
    If port = 0 Then
        MsgBox "OpenPortA failed.", vbOKOnly, "StarIO Sample"
        Exit Sub
    End If

    Dim command() As Byte
    command = StrConv("Hello World." & vbLf, vbFromUnicode)
    
    If WritePortHelper(port, command) <> UBound(command) + 1 Then
        ClosePort (port)
        MsgBox "WritePort failed.", vbOKOnly, "StarIO Sample"
        Exit Sub
    End If
    
    ClosePort (port)
    
    MsgBox "Completed successfully.", vbOKOnly, "StarIO Sample"
End Sub

Private Function WritePortHelper(port As Long, data() As Byte) As Long

    Dim zeroProgressOccurances As Long
    Dim totalSizeCommunicated As Long
    
    zeroProgressOccurances = 0
    totalSizeCommunicated = 0
    
    While (totalSizeCommunicated < UBound(data) + 1) And (zeroProgressOccurances < 2)
        Dim sizeCommunicated As Long
        sizeCommunicated = 0
        
        If WritePort(port, data(totalSizeCommunicated), UBound(data) + 1 - totalSizeCommunicated, sizeCommunicated) = 0 Then
            totalSizeCommunicated = totalSizeCommunicated + sizeCommunicated
            WritePortHelper = totalSizeCommunicated
            Exit Function
        End If
        
        If sizeCommunicated = 0 Then
            zeroProgressOccurances = zeroProgressOccurances + 1
        Else
            totalSizeCommunicated = totalSizeCommunicated + sizeCommunicated
            zeroProgressOccurances = 0
        End If
    Wend
    
    WritePortHelper = totalSizeCommunicated
End Function
